/*
          
JJMASeries.mqh 
PriceSeries.mqh 
  (): MetaTrader\experts\include\
Heiken Ashi#.mq4
  (): MetaTrader\indicators\
*/
//+------------------------------------------------------------------+  
//|                                                         JDF1.mq4 | 
//|                        Copyright  2006,        Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+  
#property copyright "Copyright  2006, Nikolay Kositsin"
#property link "farria@mail.redcom.ru" 
//----     
#property indicator_chart_window 
//----   
#property indicator_buffers 1 
//----  
#property indicator_color1 Blue 
//----    --------------------------------------------------------------------------------------------------+
extern int Length = 5;   //   
extern int Phase  = 100; // ,    -100 ... +100,     ; 
extern int Shift  = 0;   // c     
extern int Input_Price_Customs = 0;/*  ,      
(0-CLOSE, 1-OPEN, 2-HIGH, 3-LOW, 4-MEDIAN, 5-TYPICAL, 6-WEIGHTED, 7-Heiken Ashi Close, 8-SIMPL, 9-TRENDFOLLOW, 10-0.5*TRENDFOLLOW,
11-Heiken Ashi Low, 12-Heiken Ashi High,  13-Heiken Ashi Open, 14-Heiken Ashi Close.) */
//---- -------------------------------------------------------------------------------------------------------------------------------+
//----  
double Ind_Buffer[];
//----  
int Filter_size=59; 
//+------------------------------------------------------------------+  
//----+   JJMASeries 
//----+   JJMASeriesResize 
//----+   JJMASeriesAlert  
//----+   JMA_ErrDescr  
#include <JJMASeries.mqh> 
//+------------------------------------------------------------------+  
//----+   PriceSeries
//----+   PriceSeriesAlert 
#include <PriceSeries.mqh>
//+------------------------------------------------------------------+ 
//| JDF1 initialization function                                     |
//+------------------------------------------------------------------+ 
int init() 
{ 
//----     
SetIndexStyle(0,DRAW_LINE); 
//----     
SetIndexBuffer(0,Ind_Buffer);
//----   ,      
SetIndexEmptyValue(0,0.0);  
//----+      JJMASeries, nJMAnumber=1(    JJMASeries)
if (JJMASeriesResize(1)!=1)return(-1);
//----       
JJMASeriesAlert (0,"Length",Length);
JJMASeriesAlert (1,"Phase", Phase);
PriceSeriesAlert(Input_Price_Customs);
//----   ,       
SetIndexDrawBegin(0,Filter_size+30); 
//----  
return(0); 
}
//+------------------------------------------------------------------+ 
//| JDF1 iteration function                                          | 
//+------------------------------------------------------------------+  
int start()
   {
//----       
if(Bars-1<=Filter_size)return(0);  
//----      
double FILTER,Resalt;
//----+        
int reset,MaxBar,limit,bar,counted_bars=IndicatorCounted();
//----    
if (counted_bars<0)return(-1);
//----      
if (counted_bars>0) counted_bars--;
//----     ,         
limit=Bars-counted_bars-1; MaxBar=Bars-1-Filter_size;
//----      ,         
//----            
if (limit>=MaxBar)
 {
  for(bar=limit;bar>=MaxBar;bar--)Ind_Buffer[bar]=0.0; 
  limit=MaxBar;
 }     
 
//----+    
for(bar=limit;bar>=0;bar--)
 {
 FILTER=
 +0.17403451*PriceSeries(Input_Price_Customs, bar+0)
 +0.16948128*PriceSeries(Input_Price_Customs, bar+1)
 +0.16059816*PriceSeries(Input_Price_Customs, bar+2)
 +0.14781486*PriceSeries(Input_Price_Customs, bar+3)
 +0.13174065*PriceSeries(Input_Price_Customs, bar+4)
 +0.11313871*PriceSeries(Input_Price_Customs, bar+5)
 +0.09286711*PriceSeries(Input_Price_Customs, bar+6)
 +0.07184032*PriceSeries(Input_Price_Customs, bar+7)
 +0.05097190*PriceSeries(Input_Price_Customs, bar+8)
 +0.03112691*PriceSeries(Input_Price_Customs, bar+9)
 +0.01307061*PriceSeries(Input_Price_Customs, bar+10)
 -0.00256166*PriceSeries(Input_Price_Customs, bar+11)
 -0.01530251*PriceSeries(Input_Price_Customs, bar+12)
 -0.02486646*PriceSeries(Input_Price_Customs, bar+13)
 -0.03115430*PriceSeries(Input_Price_Customs, bar+14)
 -0.03425059*PriceSeries(Input_Price_Customs, bar+15)
 -0.03440925*PriceSeries(Input_Price_Customs, bar+16)
 -0.03202465*PriceSeries(Input_Price_Customs, bar+17)
 -0.02758893*PriceSeries(Input_Price_Customs, bar+18)
 -0.02167731*PriceSeries(Input_Price_Customs, bar+19)
 -0.01488347*PriceSeries(Input_Price_Customs, bar+20)
 -0.00779524*PriceSeries(Input_Price_Customs, bar+21)
 -0.00095266*PriceSeries(Input_Price_Customs, bar+22)
 +0.00517940*PriceSeries(Input_Price_Customs, bar+23)
 +0.01023922*PriceSeries(Input_Price_Customs, bar+24)
 +0.01397635*PriceSeries(Input_Price_Customs, bar+25)
 +0.01626220*PriceSeries(Input_Price_Customs, bar+26)
 +0.01708655*PriceSeries(Input_Price_Customs, bar+27)
 +0.01654358*PriceSeries(Input_Price_Customs, bar+28)
 +0.01481635*PriceSeries(Input_Price_Customs, bar+29)
 +0.01215917*PriceSeries(Input_Price_Customs, bar+30)
 +0.00887676*PriceSeries(Input_Price_Customs, bar+31)
 +0.00526401*PriceSeries(Input_Price_Customs, bar+32)
 +0.00163806*PriceSeries(Input_Price_Customs, bar+33)
 -0.00173046*PriceSeries(Input_Price_Customs, bar+34)
 -0.00461265*PriceSeries(Input_Price_Customs, bar+35)
 -0.00684073*PriceSeries(Input_Price_Customs, bar+36)
 -0.00831200*PriceSeries(Input_Price_Customs, bar+37)
 -0.00899435*PriceSeries(Input_Price_Customs, bar+38)
 -0.00891770*PriceSeries(Input_Price_Customs, bar+39)
 -0.00816700*PriceSeries(Input_Price_Customs, bar+40)
 -0.00687156*PriceSeries(Input_Price_Customs, bar+41)
 -0.00518670*PriceSeries(Input_Price_Customs, bar+42)
 -0.00327689*PriceSeries(Input_Price_Customs, bar+43)
 -0.00130327*PriceSeries(Input_Price_Customs, bar+44)
 +0.00053100*PriceSeries(Input_Price_Customs, bar+45)
 +0.00216298*PriceSeries(Input_Price_Customs, bar+46)
 +0.00346508*PriceSeries(Input_Price_Customs, bar+47)
 +0.00438724*PriceSeries(Input_Price_Customs, bar+48)
 +0.00491006*PriceSeries(Input_Price_Customs, bar+49)
 +0.00505159*PriceSeries(Input_Price_Customs, bar+50)
 +0.00485999*PriceSeries(Input_Price_Customs, bar+51)
 +0.00441031*PriceSeries(Input_Price_Customs, bar+52)
 +0.00379387*PriceSeries(Input_Price_Customs, bar+53)
 +0.00310922*PriceSeries(Input_Price_Customs, bar+54)
 +0.00245712*PriceSeries(Input_Price_Customs, bar+55)
 +0.00193159*PriceSeries(Input_Price_Customs, bar+56)
 +0.00161549*PriceSeries(Input_Price_Customs, bar+57)
 -0.00973188*PriceSeries(Input_Price_Customs, bar+58);
 
  //----+ JMA   ,  nJMA.MaxBar     nf
  //----+    JJMASeries   0,  nJMA.Phase  nJMA.Length      (nJMA.din=0)
  Resalt=JJMASeries(0,0,MaxBar,limit,Phase,Length,FILTER,bar,reset);
  //----+       
  if(reset!=0)return(-1);
  Ind_Buffer[bar]=Resalt;
     //----+
 }
//----    
return(0); 
} 
//+----------------------------------------------------------------------------+

